<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="../utilities/html/schematronHtml.xsl"?>
<sch:schema
  xmlns:sch="http://purl.oclc.org/dsdl/schematron"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  queryBinding="xslt2"
  id="EMSDataSet"
  schemaVersion="3.5.0.251001CP6"
  see="URL to human-readable documentation for this document"
  > 


  <!-- In title, keep either DEMDataSet or EMSDataSet and replace [Entity] with the name of the 
       entity supplying the file (usually a state or territory). -->
  <sch:title>NEMSIS ISO Schematron file for EMSDataSet for Texas</sch:title>

  <sch:ns prefix="nem" uri="http://www.nemsis.org"/>
  <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>

  <!-- "Initialize" variables used by nemsisDiagnostic. -->
  <sch:let name="nemsisElements" value="()"/>
  <sch:let name="nemsisElementsMissing" value="''"/>
  <sch:let name="nemsisElementsMissingContext" value="()"/>

  <!-- If you wish to use a key to lookup XML element names and translate them to their NEMSIS 
       names, uncomment the XML elements below and supply the file referenced in the include. -->

  <!-- Set up key for NEMSIS element name lookup list (look up XML element name to retrieve NEMSIS element name). -->
  <!--
  <xsl:variable name="nemSch_lookup_elements">
    <sch:include href="includes/lookup_elements.xml#nemSch_lookup_elements"/>
  </xsl:variable>
  <sch:let name="nemSch_elements" value="$nemSch_lookup_elements//*:nemSch_lookup_elements"/>
  <xsl:key name="nemSch_key_elements" match="nem:element" use="@name"/>
  -->




  <!-- PATTERNS -->


<sch:pattern id="ePatient.02">
	<sch:title>Rules for the Patient</sch:title>
	<sch:rule id="ePatientRule.02" context="nem:ePatient">
		<sch:let name="nemsisElements" value="(.)"/>
		<sch:assert role="[ERROR]" diagnostics="nemsisDiagnostic" test="./nem:ePatient.PatientNameGroup/nem:ePatient.02 !=''">
			Field ePatient.02 must be answered.  Use Unknown for unknown answer.
		</sch:assert>
	</sch:rule>
</sch:pattern>

<sch:pattern id="ePatient.03">
	<sch:title>Rules for the Patient</sch:title>
	<sch:rule id="ePatientRule.03" context="nem:ePatient">		
		<sch:let name="nemsisElements" value="(.)"/>
		<sch:assert role="[ERROR]" diagnostics="nemsisDiagnostic" test="./nem:ePatient.PatientNameGroup/nem:ePatient.03 !=''">
			Field ePatient.03 must be answered.  Use Unknown for unknown answer.
		</sch:assert>
	</sch:rule>
</sch:pattern>

<sch:pattern id="dAgency.01">
	<sch:title>Rule for the EMS DSHS ID</sch:title>
	<sch:rule id="dAgency.01Rule" context="nem:dAgency.01">
		<sch:let name="nemsisElements" value="(./nem:dAgency.01)"/>
		<sch:assert id="TX_dAgency.01" role="[ERROR]" diagnostics="nemsisDiagnostic" test="string-length(.) = 6">
			EMS Agency Unique State ID/DSHS IDs for EMS must be 6 digits long.  Please include leading zeroes if needed.
		</sch:assert>		
	</sch:rule>
</sch:pattern>

<sch:pattern id="dAgency.02">
	<sch:title>Rule for the EMS DSHS ID</sch:title>
	<sch:rule id="dAgency.02Rule" context="nem:dAgency.02">
		<sch:let name="nemsisElements" value="(./nem:dAgency.02)"/>
		<sch:assert id="TX_dAgency.02" role="[ERROR]" diagnostics="nemsisDiagnostic" test="string-length(.) = 6">
			EMS Agency Number/DSHS IDs for EMS must be 6 digits long.  Please include leading zeroes if needed.
		</sch:assert>		
	</sch:rule>
</sch:pattern>

<sch:pattern id="eResponse.01">
	<sch:title>Rule for the EMS DSHS ID</sch:title>
	<sch:rule id="eResponse.01Rule" context="nem:eResponse.01">
		<sch:let name="nemsisElements" value="(./nem:eResponse.01)"/>
		<sch:assert id="TX_eResponse.01" role="[ERROR]" diagnostics="nemsisDiagnostic" test="string-length(.) = 6">
			DSHS IDs for EMS must be 6 digits long.  Please include leading zeroes if needed.
		</sch:assert>		
	</sch:rule>
</sch:pattern>


  <!-- DIAGNOSTICS -->

    <!-- Place diagnostic elements here. -->

    <!-- Do not remove or alter the national diagnostic, nemsisDiagnostic. It is OK to replace the 
         include with the actual contents of includes/diagnostic_nemsisDiagnostic.xml. -->

     <!-- DIAGNOSTICS -->


  <sch:diagnostics>
    <?DSDL_INCLUDE_START includes/diagnostic_nemsisDiagnostic.xml?><sch:diagnostic id="nemsisDiagnostic">

  <!-- This is the NEMSIS national diagnostic. It must exist in every NEMSIS Schematron document, 
       and it should be referenced by every assert and report. It provides nationally-
       standardized, structured data to communicate which data elements are of interest in a 
       failed assert or successful report. -->

  <nemsisDiagnostic xmlns="http://www.nemsis.org" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <!-- Elements that uniquely identify the record where the problem happened. -->
    <record>
	  <xsl:copy-of select="ancestor-or-self::*:StateDataSet/*:sState/*:sState.01"/>
      <xsl:copy-of select="ancestor-or-self::*:DemographicReport/*:dAgency/(*:dAgency.01 | *:dAgency.02 | *:dAgency.04)"/>
      <xsl:copy-of select="ancestor-or-self::*:Header/*:DemographicGroup/*"/>
      <xsl:copy-of select="ancestor-or-self::*:PatientCareReport/*:eRecord/*:eRecord.01"/>
	  <xsl:if test="ancestor-or-self::*[@UUID]">
        <UUID><xsl:value-of select="ancestor-or-self::*[@UUID][1]/@UUID"/></UUID>
      </xsl:if>
    </record>
    <!-- Elements that the user may want to revisit to resolve the problem, along with their values. -->
    <elements>
      <xsl:for-each select="$nemsisElements">
        <xsl:element name="element">
          <xsl:attribute name="location">
            <xsl:apply-templates select="." mode="schematron-get-full-path"/>
          </xsl:attribute>
          <xsl:for-each select="@*">
            <xsl:attribute name="{name()}">
              <xsl:value-of select="."/>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:if test="not(*)">
            <xsl:value-of select="."/>
          </xsl:if>
        </xsl:element>
      </xsl:for-each>
    </elements>
    <!-- Elements that were missing, that the user may want to visit to resolve the problem. -->
    <elementsMissing>
      <xsl:variable name="default_context" select="."/>
      <xsl:for-each select="tokenize($nemsisElementsMissing, ' ')">
        <xsl:variable name="parent" select="$nemsisElementsMissingContext[contains(local-name(), substring-before(current(), '.'))][1]"/>
        <element>
          <xsl:attribute name="parentLocation">
            <xsl:choose>
              <xsl:when test="$parent">
                <xsl:apply-templates select="$parent" mode="schematron-get-full-path"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$default_context" mode="schematron-get-full-path"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="name">
            <xsl:value-of select="."/>
          </xsl:attribute>
        </element>
      </xsl:for-each>
    </elementsMissing>
  </nemsisDiagnostic>
</sch:diagnostic><?DSDL_INCLUDE_END includes/diagnostic_nemsisDiagnostic.xml?>
  </sch:diagnostics>

</sch:schema>
